-- Unit_CreatedFunctions.lua
-- Author: Machiavelli
-- DateCreated: 6/1/2012 9:02:22 AM
--------------------------------------------------------------

function CallSerialEventUnitCreatedGood(playerID, unitID, hexVec, unitType, cultureType, civID, primaryColor, secondaryColor, unitFlagIndex, fogState, selected, military, notInvisible)
	if(Players[playerID] == nil or
		Players[playerID]:GetUnitByID(unitID) == nil or
		Players[playerID]:GetUnitByID(unitID):IsDead() or
		Players[playerID]:GetUnitByID(unitID):IsHasPromotion(GameInfo.UnitPromotions["PROMOTION_CREATED"].ID)) then
        return;
    end

	-- Always mark the unit with the created promotion
	Players[playerID]:GetUnitByID(unitID):SetHasPromotion(GameInfo.UnitPromotions["PROMOTION_CREATED"].ID, true);

	-- Call the good event
	LuaEvents.SerialEventUnitCreatedGood(playerID, unitID, hexVec, unitType, cultureType, civID, primaryColor, secondaryColor, unitFlagIndex, fogState, selected, military, notInvisible);
end
Events.SerialEventUnitCreated.Add(CallSerialEventUnitCreatedGood);
